package DAO;

import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import ClassesJava.*;

public class BadgeDAO {
	
	/**
	 * Parametres de connexion  la base de donnes oracle URL, LOGIN et PASSWORD
	 * sont des constantes
	 */
	final static String URL = "jdbc:oracle:thin:@localhost:1521:xe";
	final static String LOGIN = "BDD5"; 
	final static String PASSWORD = "BDD5"; 
	
	public BadgeDAO() {
	//Chargement du pilote de bases de donnes
	try {
		Class.forName("oracle.jdbc.OracleDriver");
			
	}catch (ClassNotFoundException e) {
					
		System.err.println("Impossible de charger le pilote de BDD, ne pas oublier d'importer le fichier .jar dans le projet");
			}
	}
	
	
	
	/**
     * Methode inserer Badge.
     * 
     * @param Un badge
     *           
     */

	public int inserer_badge(Badge badge) {
			
		Connection connexion = null;
		PreparedStatement ps = null;
		
		//Variable permettant de confirmer la fin du processus
		int retour = 0;

		// Connexion  la Base de donnes

		try {
			// Tentative de connexion
			connexion = DriverManager.getConnection(URL, LOGIN, PASSWORD);
			// Prparation de l'instruction SQL: chaque "?" reprsente une valeur
			//  communiquer dans l'insertion
			// Les getters permettent de rcuperer les valeurs des attributs
			// souhaits
				ps = connexion.prepareStatement("INSERT INTO BADGE (IDBADGE, IDPERSONNE_BADGE) VALUES (BADGES_SEQUENCE.NEXTVAL, ?)");
				ps.setInt(1, badge.getIdpersonne());
				

				// Excution de la requete
				retour = ps.executeUpdate();

			} catch (Exception e) {
				e.printStackTrace();
			} finally {
				// fermeture du preparedStatement et de la connexion
				try {
					if (ps != null)
						ps.close();
				} catch (Exception ignore) {
				}
				try {
					if (connexion != null)
						connexion.close();
				} catch (Exception ignore) {
				}
			}
		
			return retour;
	}
	
	/**
     * Methode Supprimer Badge.
     * 
     * @param Un badge
     *           
     */
	
	public int supprimer_badge(Badge badge) {
		
		Connection connexion = null;
		PreparedStatement ps = null;
		
		//Variable permettant de confirmer la fin du processus
		int retour = 0;

		// Connexion  la Base de donnes

		try {
			// Tentative de connexion
			connexion = DriverManager.getConnection(URL, LOGIN, PASSWORD);
			// 
			// 
				ps = connexion.prepareStatement("DELETE FROM BADGE WHERE IDPERSONNE_BADGE = ?" );		
				
				ps.setInt(1, badge.getIdpersonne());

				// Excution de la requete
				retour = ps.executeUpdate();

			} catch (Exception e) {
				e.printStackTrace();
			} finally {
				// fermeture du preparedStatement et de la connexion
				try {
					if (ps != null)
						ps.close();
				} catch (Exception ignore) {
				}
				try {
					if (connexion != null)
						connexion.close();
				} catch (Exception ignore) {
				}
			}
			return retour;
		
	}
	
	/**
     * Methode getBadge.
     * 
     * @param l'id d'une personne
     *           
     */
	
	public Badge getBadge(int idpersonne) {

		Connection con = null;
		PreparedStatement ps = null;
		ResultSet rs = null;
		Badge retour = null;

		// connexion à la base de données
		try {

			con = DriverManager.getConnection(URL, LOGIN, PASSWORD);
			ps = con.prepareStatement("SELECT * FROM BADGE WHERE IDPERSONNE_BADGE = ?");
			ps.setInt(1, idpersonne);

			// on exécute la requête
			// rs contient un pointeur situé juste avant la première ligne
			// retournée
			rs = ps.executeQuery();
			// passe à la première (et unique) ligne retournée
			if (rs.next())
				retour = new Badge(rs.getInt("IDPERSONNE_BADGE"));

		} catch (Exception ee) {
			
			ee.printStackTrace();
			
		} finally {
			// fermeture du ResultSet, du PreparedStatement et de la Connexion
			try {
				if (rs != null)
					rs.close();
			} catch (Exception ignore) {
			}
			try {
				if (ps != null)
					ps.close();
			} catch (Exception ignore) {
			}
			try {
				if (con != null)
					con.close();
			} catch (Exception ignore) {
			}
		}
		return retour;

	}	
	
}
